package com.flashdynamix.motion.easing {

	/**
	 * Ease params designed specifically for use with the Elastic ease equation.
	 * 
	 * @see com.flashdynamix.motion.TweensyTimeline#easeParams
	 * @see fl.motion.easing.Elastic
	 */
	public dynamic class ElasticEaseParams extends Array {
		
		/**
		 * @param amplitude Sets the amplitude (how much) of the sine wave for the Elastic tween.
		 * @param period  Sets the period (how often) of the sine wave for the Elastic tween.
		 */
		public function ElasticEaseParams(amplitude : Number = 0.7, period : Number = 0.3) {
			super([]);
			this.amplitude = amplitude;
			this.period = period;
		}

		public function set amplitude(amount : Number) : void {
			this[0] = amount;
		}
		
		/**
		 * Sets and returns the amplitude (how much) of the sine wave for the Elastic tween.
		 */
		public function get amplitude() : Number {
			return this[0];
		}

		public function set period(amount : Number) : void {
			this[1] = amount;
		}
		
		/**
		 * Sets and returns the period (how often) of the sine wave for the Elastic tween.
		 */
		public function get period() : Number {
			return this[1];
		}
	}
}
